/**
 * 
 */
package gov.va.med.mhv.usermgmt.test.builder;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.ServiceResponse;

import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.BloodTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ContactMethodEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.CountryEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.GenderEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.MaritalStatusEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.PasswordHintQuestionEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.StateEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.TitleEnumeration;
import gov.va.med.mhv.usermgmt.service.ActivityCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.ActivityServiceResponse;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationServiceResponse;
import gov.va.med.mhv.usermgmt.service.PatientServiceResponse;
import gov.va.med.mhv.usermgmt.service.UserProfileServiceResponse;
import gov.va.med.mhv.usermgmt.service.delegate.EntityMaintenanceServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.PatientServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.service.delegate.UserProfileServiceDelegate;
import gov.va.med.mhv.usermgmt.transfer.Activity;
import gov.va.med.mhv.usermgmt.transfer.EmergencyContact;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;

/**
 * @author Rob Proper
 *
 */
public class UserProfileUtil {
	
	private static final Log LOG = LogFactory.getLog(UserProfileUtil.class);

	public static String generateUserName() {
		int currentYear = Calendar.getInstance().get(Calendar.YEAR);
		long epoch = DateUtil.createDate(Calendar.JANUARY, 1, currentYear).
			getTime();
		long elapsed = Calendar.getInstance().getTimeInMillis() - epoch;
		String userName = Long.toHexString(elapsed);
		if (userName.length() < 6) {
			StringUtils.leftPad(userName, 6 - userName.length(), '0');
		}
		return userName;
	}
	
	public static String createInvalidPassword(String password) { 
		return (StringUtils.isBlank(password)) ? "dontcare" 
			: ((password.length() > 1) ? password.substring(1) : "dontcare"); 
	}
	
	public static String createResetPassword() { 
		String password = "%dontcare0";
		if(!StringUtils.isBlank(password) && (password.length() > 1)) {
			char ch = password.charAt(0);
			if (Character.isDigit(ch)) {
				ch = (ch == '0') ? '1' : '0';
			} else if (Character.isLetter(ch)) {
				ch = (ch == 'a') ? 'b' : 'a'; 
			} else {
				ch = (ch == '%') ? '$' : '%';
			}
			password = "" + ch + password.substring(1); 
		}
		return password;
	}

	public static UserProfile createUserProfile(String userName, 
		String firstName, String middleName, String lastName, Date birthDate) 
	{
		return createUserProfile(userName, firstName, middleName, lastName, 
			birthDate, null, Boolean.FALSE);
	}
    
    public static void addEmergencyContact(UserProfile userProfile,
        boolean isPrimary, String firstName, String lastName,
        ContactMethodEnumeration method, String homePhone, String workPhone, 
        String mobilePhone, String email)
    {
        if (userProfile == null) {
            return;
        }
        EmergencyContact contact = TransferObjectFactory.
            createEmergencyContact();
        contact.setIsPrimary(isPrimary);
        contact.setFirstName(firstName);
        contact.setLastName(lastName);
        contact.setContactInfoContactMethod(method);
        contact.setContactInfoHomePhone(homePhone);
        contact.setContactInfoWorkPhone(workPhone);
        contact.setContactInfoMobilePhone(mobilePhone);
        contact.setContactInfoEmail(email);
        userProfile.addEmergencyContact(contact);    
    }

	public static UserProfile createUserProfile(String userName, 
		String firstName, String middleName, String lastName, Date birthDate, 
		String ssn, Boolean isPatient) 
	{
		UserProfile userProfile = TransferObjectFactory.createUserProfile();
		userProfile.setUserName(userName);
		userProfile.setFirstName(firstName);
		userProfile.setLastName(lastName);
		userProfile.setMiddleName("");
		userProfile.setBirthDate(birthDate);
		userProfile.setTitle(TitleEnumeration.getEnum(TitleEnumeration.MR));
		userProfile.setBloodType(BloodTypeEnumeration.getEnum(
			BloodTypeEnumeration.O_NEGATIVE));
		userProfile.setIsOrganDonor(Boolean.TRUE);
		userProfile.setGender(GenderEnumeration.getEnum(GenderEnumeration.MALE));
		userProfile.setMaritalStatus(MaritalStatusEnumeration.getEnum(
			MaritalStatusEnumeration.DIVORCED));
		userProfile.setIsVeteran(Boolean.TRUE);
		userProfile.setAddressStreet1("1 Some Street");
		userProfile.setAddressCity("Nowhere Town");
		userProfile.setAddressState(StateEnumeration.getEnum(StateEnumeration.VA));
		userProfile.setAddressPostalCode("12345");
		userProfile.setAddressCountry(CountryEnumeration.getEnum(
			CountryEnumeration.UNITED_STATES));
		userProfile.setContactInfoContactMethod(ContactMethodEnumeration.getEnum(
			ContactMethodEnumeration.HOMEPHONE));
		userProfile.setContactInfoHomePhone("555-555-5555");
		userProfile.setContactInfoEmail(firstName + "." + lastName + 
			"serv.domain.ext");
		userProfile.setPasswordHintQuestion1(PasswordHintQuestionEnumeration.
			getEnum(PasswordHintQuestionEnumeration.FAVORITEFOOD));
		userProfile.setPasswordHintAnswer1("Pizza");
		userProfile.setPasswordHintQuestion2(PasswordHintQuestionEnumeration.
			getEnum(PasswordHintQuestionEnumeration.PETNAME));
		userProfile.setPasswordHintAnswer2("Spot");
		userProfile.setAcceptDisclaimer(Boolean.TRUE);
		userProfile.setAcceptPrivacy(Boolean.TRUE);
		userProfile.setAcceptTerms(Boolean.TRUE);
		userProfile.setSsn(ssn);
		userProfile.setIsPatient(BooleanUtils.isTrue(isPatient));
		return userProfile;
	}

	public UserProfile find(String userName) {
		if (StringUtils.isBlank(userName)) {
			return null;
		}
		UserProfileServiceDelegate delegate = ServiceDelegateFactory.
			createUserProfileServiceDelegate();
		UserProfileServiceResponse response = delegate.getProfileForUser(
			userName);
		MessageHandler.handleMessages(response, "Finding user profile '" 
			+ userName + "'", LogLevel.Error);
		return response.getUserProfile();
	}


	public static void delete(UserProfile userProfile) {
		if (userProfile == null) {
			return;
		}
    	deletePatientForUser(userProfile);
    	deleteActivities(userProfile);
        removeUserProfileContacts(userProfile);
		ServiceResponse response = ServiceDelegateFactory.
			createEntityMaintenanceServiceDelegate().delete(
				userProfile.getUserProfilePK());
		if (response.getMessages().hasErrorMessages()) {
			LOG.warn("Deleting existing user profile for user '" 
				+ userProfile.getUserName() + "': " + response.getMessages().
				getErrorMessages());
		}
		
	}

//	private static  void deletePasswordHistory(UserProfile userProfile) {
//		ActivityCollectionServiceResponse response = ServiceDelegateFactory.
//			createUserProfileServiceDelegate().
//			
//			
//		MessageHandler.handleMessages(response, "Unable to delete activities");
//		
//		EntityMaintenanceServiceDelegate delegate = 
//			ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();
//		for (Iterator i = response.getActivitys().iterator(); i.hasNext();) {
//			Activity activity = (Activity) i.next();
//			if (activity != null) {
//				ActivityServiceResponse r = delegate.delete(activity.
//					getActivityPK());
//				MessageHandler.handleMessages(r, "Unable to delete activity [" 
//					+ activity.getActivityId() + "]");
//			}
//		}
//	}
//

	private static  void deleteActivities(UserProfile userProfile) {
		Calendar calendar = Calendar.getInstance();
		Timestamp from = new Timestamp(calendar.getTimeInMillis());
		calendar.add(Calendar.YEAR, -100);
		Timestamp to = new Timestamp(calendar.getTimeInMillis());
		ActivityCollectionServiceResponse response = ServiceDelegateFactory.
			createActivityAuditServiceDelegate().
			getActivitiesForSubject(userProfile.getId(),
			ActivityActorTypeEnumeration.SELF, from, to);
		MessageHandler.handleMessages(response, "Unable to delete activities");
		
		EntityMaintenanceServiceDelegate delegate = 
			ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();
		for (Iterator i = response.getActivitys().iterator(); i.hasNext();) {
			Activity activity = (Activity) i.next();
			if (activity != null) {
				LOG.debug("Delete activity " + activity.getEntityName());
				ActivityServiceResponse r = delegate.delete(activity.
					getActivityPK());
				MessageHandler.handleMessages(r, "Unable to delete activity [" 
					+ activity.getActivityId() + "]");
			}
		}
	}

    private static void removeUserProfileContacts(UserProfile userprofile) {
        LOG.debug("Deleting user profile contacts");
        userprofile.setEmergencyContacts(null);
        ServiceResponse r = ServiceDelegateFactory.
            createEntityMaintenanceServiceDelegate().save(userprofile);
        MessageHandler.handleMessages(r, "Unable to delete user contacts"); 
    }


	private static  void deletePatientForUser(UserProfile userprofile) {
		PatientServiceDelegate delegate = ServiceDelegateFactory.
			createPatientServiceDelegate();
		PatientServiceResponse response = delegate.getPatientForUser(
			userprofile);
		MessageHandler.handleMessages(response, 
			"Unable to delete patient for user");
		Patient patient = response.getPatient();
		if (patient != null) {
			LOG.debug("Deleting patient " + patient.getUserProfile().
				getUserName());
			deleteIPAsForPatient(patient);
			removePatientFacilities(patient);
			removePatientRegistryChanges(patient);
			ServiceResponse r = ServiceDelegateFactory.
				createEntityMaintenanceServiceDelegate().delete(
				patient.getPatientPK());
			MessageHandler.handleMessages(r, "Unable to delete patient");
		}
	}

	private static void deleteIPAsForPatient(Patient patient) {
		LOG.debug("Deleting patient IPAs");
		InPersonAuthenticationServiceResponse response = ServiceDelegateFactory.
			createInPersonAuthenticationServiceDelegate().
			getAuthenticationForPatient(patient.getId());
		MessageHandler.handleMessages(response, "Unable to delete IPA records");
		
		InPersonAuthentication ipa = response.getInPersonAuthentication();
		if (ipa != null) {
			ServiceResponse r = ServiceDelegateFactory.
				createEntityMaintenanceServiceDelegate().delete(
				ipa.getInPersonAuthenticationPK());
			MessageHandler.handleMessages(r, "Unable to delete IPA [" + 
				ipa.getId() + "]");
		}
	}

	private static  void removePatientFacilities(Patient patient) {
		LOG.debug("Deleting patient facilities");
		patient.setFacilitys(null);
		ServiceResponse r = ServiceDelegateFactory.
			createEntityMaintenanceServiceDelegate().save(patient);
		MessageHandler.handleMessages(r, "Unable to delete patient"); 
	}

	private static  void removePatientRegistryChanges(Patient patient) {
		LOG.debug("Deleting patient registry changes");
		patient.setPatientRegistryChanges(null);
		ServiceResponse r = ServiceDelegateFactory.
		createEntityMaintenanceServiceDelegate().save(patient);
		MessageHandler.handleMessages(r, "Unable to delete patient"); 
	}

//	private static  void handleMessages(ServiceResponse response, 
//		String message) 
//	{
//		if (response.getMessages().hasErrorMessages()) {
//			throw new IllegalStateException(message + ": " 
//				+ response.getMessages().getErrorMessages());
//		}
//	}

	
}
